<?php 

/* 
 -- =============================================
-- Author:			<Emmanuel Gabion>
-- Create date: 	<11/5/2013>
-- Last Modified: 	<11/5/2013>
-- Description:		< Additional generic Functions Requested for optimal database usage>
-- =============================================
  */
 
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');

// class Generic extends CI_Controller {
class Generic_mod extends AccessTemplate {
	
	public function __construct(){
		parent::__construct();
		$this->load->model('api_seatplans_model', 'seatplans');
		$this->load->model('api_events_model', 'events');
		$this->load->model('api_sections_model', 'sections');
		$this->load->model('api_transaction_model', 'transaction');
		$this->load->model('api_events_model', 'events');
		$this->load->model('api_prices_model', 'prices');
		$this->load->model('api_tickets_model', 'tickets');
		$this->load->model('api_payments_model', 'payments');
		$this->load->model('api_ticket_types_model', 'ticket_types');
		$this->load->model('api_ip_model', 'ip');
		$this->load->model('api_ticket_layouts_model', 'ticket_layouts');
		$this->load->model('api_bcode_model', 'bcode');
		$this->load->model('api_promo_codes_model', 'promo');
		$this->load->model('api_authentication_model', 'authentication');
		$this->load->database('default',true); 
	}
	
	function template() {
			
		// the date today
		$today = date("Y-m-d");
		$today = '2013-02-11';
		
		
		
		$dbAccess->select("
				evt.event_code
				, evt.event_title
				, evt.event_long_title
				, evt.event_date_time
			");
			
		$dbAccess->where("evt.event_date_time > '$today 00:00:00'");
		$dbAccess->where("evt.event_date_time < '$today 23:59:59'");
		$dbAccess->where("evt.event_active", 1);
		$query = $dbAccess->get('events evt');
	
	
		$this->load->dbutil();
		
		$config = array (
			  'root'    => 'root',
			  'element' => 'sections', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);

			
		$xmloutput = $this->dbutil->xml_from_result($query, $config);
		echo $xmloutput;

	}
	

	var $errorMessage = array (
		'ER:00' => 'Incomplete/Invalid Parameters.',
		'ER:01' => 'Invalid access.',
		'ER:02' => 'Inactive KEY',
		'ER:04' => 'In',
		'ER:05' => 'Relay problem and error encountered while storing data. Please contact MGI.',
		'ER:06' => 'Relay problem and error encountered while storing data. Please contact MGI.',
		);
	
	//============================== D A T A S Y N C  M O D E  =======================================
	//======= P a r t y L i n e   A u t h e n t i c a t i o n   P r o t o c o l =======
	 			 

		/* 	GetActiveEventsFullMarket_NoDesc()||CREATE DATE: <11/5/2013>||LAST MODIFIED: <11/5/2013>
			Description: List of full details of Active events from 'market' database minus the event description */
	
	// Get_Active_Events_Full_Market_NoDesc() 	
	function GetActiveEventsFullMarket_NoDesc(){
		
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		$event_id = $this->input->get_post('eventid');
		$event = $this->input->get_post('event');
		
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}else{
			
					$sessionStatus = $this->checkTokenStatus($appcode,$livetoken);
					
					if($sessionStatus == "nonexistent"){
					$this->promptError('ER:02:02');
					}elseif($sessionStatus == "expired"){
					$this->promptError('ER:03:01');
					}else{	

					$dbAccess = $this->load->database('default',true);

					$dbAccess->select('evt.event_id,	
					evt.event_code,
					evt.event_title,
					evt.event_long_title,
					evt.event_date_time,
					evt.event_description,
					evt.event_image,
					evt.event_image_1,
					evt.event_seatplan_id,
					evt.event_recommended,
					s.seatplan_image,
					evt.event_venue_id,
					evt.event_internet_sales_charge as convenience_charge,
					evt.event_type,
					ec.events_config_ekbarcode_active,
					evt.event_active,
					evt.event_ticket_types,
					evt.event_hotel,
					evt.event_always_show,
					evt.event_online_registration');
						
				
					$dbAccess->where("evt.event_active",'1');
					$dbAccess->where("evt.event_date_time >= now()");

					$dbAccess->join('events_config ec', 'ec.events_config_eventid = evt.event_id', 'left' );

					$dbAccess->join('seatplans s', 's.seatplan_id = evt.event_seatplan_id', 'left' );

					if($event_id){
						$dbAccess->where("evt.event_id", $event_id);
					}

					if($event){
					$dbAccess->like('evt.event_long_title', $event);
					}

					$query = $dbAccess->get('events evt');

				
					$data['eventDetails'] = $query->result();
			
				//display the page
				$this->load->view('event_details_xml_NoDesc', $data);
			 }
		 }

		}
		/* End of GetActiveEventsFullMarket_NoDesc() */
		
		
		
		/* 	GetActiveEventsbyType()||CREATE DATE: <11/5/2013>||LAST MODIFIED: <11/5/2013>
		Description: List of basic details of Active events from 'market' database BY EVENT TYPE and minus event description */
		
		// Get_Active_Events_by_Type()
		function GetActiveEventsbyType(){
		
			$appcode = $this->input->get_post('appcode');
			$livetoken = $this->input->get_post('livetoken');
			$event_type = $this->input->get_post('type');
			
			if(!$appcode){
				$this->promptError('ER:01:03');
			}elseif(!$livetoken){
				$this->promptError('ER:01:04');			
			}elseif(!$event_type){
				$this->promptError('ER:05:18');
			}else{
				
					$sessionStatus = $this->checkTokenStatus($appcode,$livetoken);
					
					if($sessionStatus == "nonexistent"){
					$this->promptError('ER:02:02');
					}elseif($sessionStatus == "expired"){
					$this->promptError('ER:03:01');
					}else{	

						$dbAccess = $this->load->database('market',true);


						$queryString = "SELECT 
								evt.event_id
								,evt.event_code
								, evt.event_title
								, evt.event_long_title
								, evt.event_date_time
								, evt.event_internet_sales_charge as convenience_charge
								, ec.events_config_ekbarcode_active
								FROM (`events` evt) 
								LEFT JOIN `events_config` ec ON `ec`.`events_config_eventid` = `evt`.`event_id` 
								LEFT JOIN `seatplans` s ON `s`.`seatplan_id` = `evt`.`event_seatplan_id` 
								WHERE `evt`.`event_active` = 1 and event_date_time >= now() and `evt`.event_type = '$event_type'";
										
								$query = $dbAccess->query($queryString);
								$data['eventDetails'] = $query->result();

						//display the page
						$this->load->view('active_events_xml', $data);
						
					}
			}
		}
		/* End of GetActiveEventsbyType() */
		

		/* 	GetSchedbyEventID()||CREATE DATE: <11/5/2013>||LAST MODIFIED: <11/5/2013>
			Description: List of event id and their event date from 'market' database BY event id*/
		
		// Get_Sched_by_EventID()
		function GetSchedbyEventID(){
	
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		$event_id = $this->input->get_post('eventid');
		
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');			
		}elseif(!$event_id){
			$this->promptError('ER:05:03');
		}else{
			
					$sessionStatus = $this->checkTokenStatus($appcode,$livetoken);
					
					if($sessionStatus == "nonexistent"){
					$this->promptError('ER:02:02');
					}elseif($sessionStatus == "expired"){
					$this->promptError('ER:03:01');
					}else{	

					$dbAccess = $this->load->database('market',true);


					$queryString = "SELECT 
							evt.event_id
							, evt.event_date_time
							FROM (`events` evt) 
							LEFT JOIN `events_config` ec ON `ec`.`events_config_eventid` = `evt`.`event_id` 
							LEFT JOIN `seatplans` s ON `s`.`seatplan_id` = `evt`.`event_seatplan_id` 
							WHERE `evt`.`event_active` = 1 and event_date_time >= now()  and `evt`.`event_id` =  '$event_id' ";
				
							$query = $dbAccess->query($queryString);
							$data['eventDetails'] = $query->result();

					//display the page
					$this->load->view('active_events_sched', $data);
					
				}
		}
	}
		/* End of GetSchedbyEventID() */
	
	
		/* 	GetPriceSectionbyID()||CREATE DATE: <11/5/2013>||LAST MODIFIED: <11/5/2013>
			Description: List of Prices and their Sections by Price ID */
		// Get_Price_Section_by_ID()
		function GetPriceSectionbyID(){
			
				$price_id = $this->input->get_post('priceid');
				$appcode = $this->input->get_post('appcode');
				$livetoken = $this->input->get_post('livetoken');
				
				if(!$appcode){
					$this->promptError('ER:01:03');
				}elseif(!$livetoken){
					$this->promptError('ER:01:04');
				}elseif(!$price_id){
					$this->promptError('ER:05:07');
				}else{
				
					$sessionStatus = $this->checkTokenStatus($appcode,$livetoken);
					
					if($sessionStatus == "nonexistent"){
					$this->promptError('ER:02:02');
					}elseif($sessionStatus == "expired"){
					$this->promptError('ER:03:01');
					}else{	
					
				
						$data['price'] = $this->prices->get($price_id);
							$this->load->view('price_xml', $data);
							
					}
				}

			}
		/* End of GetPriceSectionbyID() */
	
		/* 	GetSectionByID()||CREATE DATE: <11/5/2013>||LAST MODIFIED: <11/5/2013>
			Description: List of Sections and their Seats by Section ID */
		// Get_Section_By_ID()
		function GetSectionByID(){

			$appcode = $this->input->get_post('appcode');
			$livetoken = $this->input->get_post('livetoken');
			$section_id = $this->input->get_post('id');
			
			if(!$appcode){
				$this->promptError('ER:01:03');
			}elseif(!$livetoken){
				$this->promptError('ER:01:04');
			}elseif(!$section_id){
				$this->promptError('ER:05:05');
			}else{

				$sessionStatus = $this->checkTokenStatus($appcode,$livetoken);
					
					if($sessionStatus == "nonexistent"){
					$this->promptError('ER:02:02');
					}elseif($sessionStatus == "expired"){
					$this->promptError('ER:03:01');
					}else{	

						$data['section'] = $this->sections->get($section_id);

						//display the page
						$this->load->view('section_info', $data);
				}
			
			}

		}
		/* End of GetSectionByID() */ 

			

			
			

		function nt_GetActiveEventsbyType($event_type=false){
		

			$dbAccess = $this->load->database('market',true);

			$dbAccess->select("
			evt.event_id
			, evt.event_code
			, evt.event_title
			, evt.event_long_title
			, evt.event_date_time
			, evt.event_internet_sales_charge as convenience_charge
			, evt.event_max_ticket
			, ec.events_config_ekbarcode_active
			");	

			$dbAccess->join('events_config ec', 'ec.events_config_eventid = evt.event_id', 'left' );
			$dbAccess->join('seatplans s', 's.seatplan_id = evt.event_seatplan_id', 'left' );
			$dbAccess->where("evt.event_active",1);
			$dbAccess->where("evt.event_date_time >= now()");
			$dbAccess->where("evt.event_type",$event_type);
			$query = $dbAccess->get("events evt")->result();
			
			$data['eventDetails'] = $query;

			//display the page
			$this->load->view('active_events_xml', $data);
	
		}

		function nt_GetActiveEventsFullMarket_NoDesc(){

			$event_id = $this->input->get_post('eventid');
			$event = $this->input->get_post('event');
			$event_type = $this->input->get_post('eventtype');

				$dbAccess = $this->load->database('default',true);
				$dbAccess->select('evt.event_id,	
				evt.event_code,
				evt.event_title,
				evt.event_long_title,
				evt.event_date_time,
				evt.event_description,
				evt.event_image,
				evt.event_image_1,
				evt.event_seatplan_id,
				evt.event_recommended,
				s.seatplan_image,
				evt.event_venue_id,
				v.venue_name,
				evt.event_internet_sales_charge as convenience_charge,
				evt.event_type,
				ec.events_config_ekbarcode_active,
				evt.event_active,
				evt.event_ticket_types,
				evt.event_hotel,
				evt.event_always_show,
				evt.event_online_registration');

				$dbAccess->where("evt.event_active",'1');
				$dbAccess->where("evt.event_date_time >= now()");
				$dbAccess->join('events_config ec', 'ec.events_config_eventid = evt.event_id', 'left' );
				$dbAccess->join('seatplans s', 's.seatplan_id = evt.event_seatplan_id', 'left' );
				$dbAccess->join('venues v', 'v.venue_id = evt.event_venue_id', 'left' );

				if($event_id){
					$dbAccess->where("evt.event_id", $event_id);
				}
				if($event){
				$dbAccess->like('evt.event_long_title', $event);
				}
				
				if($event_type){
				$dbAccess->where("evt.event_type",$event_type);
				}

				$query = $dbAccess->get('events evt');

			
				$data['eventDetails'] = $query->result();
		
			//display the page
			$this->load->view('event_details_xml_NoDesc', $data);
		 }
		
						
	function nt_getHotEvents($limit=false){

	// $limit = 6;
	$dbAccess = $this->load->database('default',true);
	$date = date( 'Y-m-d H:i:s',strtotime("-720 minutes"));

		$queryString = "SELECT COUNT(e.event_title) AS COUNT ,
					e.event_id, e.event_title, e.event_code, 
					e.event_long_title, 
					e.event_date_time, 
					e.event_description, 
					e.event_image, 
					e.event_image_1, 
					e.event_seatplan_id, 
					e.event_recommended,
					 s.seatplan_image, 
					 e.event_venue_id, 
					 v.venue_name, 
					 e.event_internet_sales_charge AS convenience_charge, 
					 e.event_type, 
					 ec.events_config_ekbarcode_active, 
					 e.event_active, 
					 e.event_ticket_types, 
					 e.event_hotel, 
					 e.event_always_show,
					 e.event_online_registration

					FROM (tickets)
					JOIN prices ON prices.price_id = tickets.ticket_price_id
					JOIN `events` e ON e.event_id = prices.price_event_id

					 JOIN events_config ec ON ec.events_config_eventid = e.event_id
					 JOIN seatplans s ON s.seatplan_id = e.event_seatplan_id
					 JOIN venues v ON v.venue_id = e.event_venue_id

					WHERE ticket_date_entered >= '$date' and e.event_active = '1'
					GROUP BY e.event_title
					ORDER BY COUNT DESC";
					
	
	
	
	if($limit){
		$queryString = $queryString . " LIMIT $limit";
	}
	

	
	$query = $dbAccess->query($queryString);
	
	// echo $dbAccess->last_query();
	// die();
	
	$data['eventDetails'] = $query->result();

	// echo "<pre>";
	// print_r($data['eventDetails']);
	// echo "</pre>";
	// die();

	
	//display the page
	$this->load->view('event_details_xml_NoDesc', $data);
	
	}
		
				
	function nt_getHotEvents_2($limit=false){

	$dbAccess = $this->load->database('default',true);
	$date = date( 'Y-m-d H:i:s',strtotime("-10000 minutes"));

	$queryString = "SELECT count(e.event_title) as count
					,e.event_id
					,e.event_title
					FROM (tickets)
					JOIN prices ON prices.price_id = tickets.ticket_price_id
					JOIN events e ON e.event_id = prices.price_event_id
					WHERE e.event_active = '1' and ticket_date_entered >= '$date'
					group by e.event_title, e.event_long_title
					order by count desc";
					


	if($limit){
		$queryString = $queryString . " LIMIT $limit";
	}

	// echo $queryString;
	// die();
	
	$query = $dbAccess->query($queryString);

	$most_ticket_selected = $query->result();


	
	
	
	// echo "<pre>";
	// print_r($most_ticket_selected);
	// echo "</pre>";
	// die();
	
	

	header ("Content-Type:text/xml");
	echo "<root>";

	foreach($most_ticket_selected as $most_selected){
		echo "<event_info>" ;

			echo "<selection_count>" . $most_selected->count . "</selection_count>";
			echo "<event_id>" . htmlentities($most_selected->event_id) . "</event_id>";

		echo "</event_info>";
	}

	echo "</root>";
	
	
	}
				
		
		
		
		function nt_getActiveEventsForListing(){

			
			$event_id = $this->input->get_post('id');
			$event_match = $this->input->get_post('match');
			$event_type = $this->input->get_post('type');
			$long_title = $this->input->get_post('title');
			$venue = $this->input->get_post('venue');

			$json = $this->input->get_post('json');

				$dbAccess = $this->load->database('market',true);
				$dbAccess->select('	e.event_id
									,e.event_active
									,e.event_title
									,e.event_long_title
									,e.event_image_1
									,e.event_date_time
									,e.event_announcement_date
									,e.event_tags
									,e.event_type
									,e.event_parent
									,e.date_modified as event_date_modified
									,v.venue_id,
									,v.venue_name,
									');

				$dbAccess->where("e.event_active",'1');
				
				$dbAccess->where("e.event_date_time >= now()");
				$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );

				if($event_id){
					$dbAccess->where("e.event_id", $event_id);
				}
				
				if($event_match){
				$dbAccess->like('e.event_tags',$event_match);
				}
				
				if($event_type){
				$dbAccess->where("e.event_type",$event_type);
				}
				
				if($venue){
				$dbAccess->where("e.event_venue_id",$venue);
				}

				if($long_title){
				$dbAccess->where("e.event_long_title",$long_title);
				}else{
				// $dbAccess->where("e.event_parent",0);
				}
				
				$dbAccess->order_by('e.event_title',"asc");
				
				$query = $dbAccess->get('events e');
				
				$data['events'] = $query->result();
	
	
				// echo $dbAccess->last_query();
				// die();
				
				
					// echo "<pre>";
					// print_r($query->result());
					// echo "</pre>";
				
				
	
				 if(!$json){
					//display the page
					$this->load->view('events_listing_xml', $data);
				}else{
					// $this->output->set_content_type('application/json');
					
					echo json_encode($query->result());
					
					// echo "<pre>";
					// print_r($query->result());
					// echo "</pre>";
					
					
					die();
				} 
				
				
		 }
		 
		  
		 
		 /* ACCOUNT */
		 

	// Get_Sections_For_All_ActiveEvents()
	function nt_GetSectionsforAllActiveEvents(){

		$event_id = $this->input->get_post('eventid');
		$data['sections'] = $this->sections->getSectionsWithEventID($event_id);

		if(!$data['sections']){
		$this->load->view('blank', $data);
		}else{
		//display the page
		$this->load->view('seatplans_active_events_xml', $data);
		}

	}
	
		// Get_Venues_For_All_Active_Events()
	function nt_GetVenueListForAllActiveEvents(){
		
		$venue_id = $this->input->get_post('venueid');
		$dbAccess = $this->load->database('default',true);
		
		$dbAccess->select("	v.venue_id
							,v.venue_type
							, v.venue_name
							, v.venue_address1");
			
		$dbAccess->distinct();
		$dbAccess->join('events e','e.event_venue_id = v.venue_id');
		$dbAccess->where("e.event_date_time >= now()");
		$dbAccess->where('e.event_active',1);
		
		if($venue_id){
		$dbAccess->where('v.venue_id',$venue_id);
		}

		$query = $dbAccess->get('venues v');
		$content = $query->result();
		$data['Venues'] = $content;
		$this->load->view('venues_xml', $data);
	}
	
	
	
		// Get_Active_Events_Full_Market()
		function GetActiveEventsFullMarket_new(){
		
			$event_id = $this->input->get_post('eventid');
			$dbAccess = $this->load->database('default',true);
	
			$dbAccess->select('evt.event_id,	
			evt.event_code,
			evt.event_title,
			evt.event_long_title,
			evt.event_date_time,
			evt.event_description,
			evt.event_image,
			evt.event_image_1,
			evt.event_seatplan_id,
			evt.event_recommended,
			evt.event_description,
			s.seatplan_image,
			evt.event_venue_id,
			v.venue_name,
			evt.event_internet_sales_charge as convenience_charge,
			evt.event_type,
			ec.events_config_ekbarcode_active,
			evt.event_active,
			evt.event_ticket_types,
			evt.event_hotel,
			evt.event_always_show,
			evt.event_online_registration,
			evt.event_parent,
			evt.event_max_ticket');
				
				
				$dbAccess->where("evt.event_active",'1');
				$dbAccess->where("evt.event_date_time >= now()");

				$dbAccess->join('events_config ec', 'ec.events_config_eventid = evt.event_id', 'left' );
				$dbAccess->join('venues v', 'v.venue_id = evt.event_venue_id', 'left' );

				$dbAccess->join('seatplans s', 's.seatplan_id = evt.event_seatplan_id', 'left' );

				if($event_id){
					$dbAccess->where("evt.event_id", $event_id);
				}

				$query = $dbAccess->get('events evt');

				
				
				
				// echo $dbAccess->last_query();
				// echo "<pre>";
				// print_r(	$query->result()	);
				// echo "</pre>";
				// die();
				
				$data['eventDetails'] = $query->result();
			
				//display the page
				$this->load->view('event_details_xml_new', $data);
		}
		 
		
		//no tokens for ticket master
		
			// Get_Transaction_Details()
 	
	// Get_Customer_Transactions()
	function nt_GetCustomerTransactions(){

 		$customerid = $this->input->get_post('customerid');
	 
		$data['transactions'] = $this->transaction->get_customer_transactions($customerid);
		 
		if(empty($data['transactions'])){
		$this->promptError('ER:04:22');
		}else{
		//display the page
		$this->load->view('customer_transactions_xml', $data);
		}
	}
	
	//di ko na ginamit -korewa
	function nt_GetCustomerDetails(){

 		$customerid = $this->input->get_post('customerid');
	 
		$data['customer'] = $this->transaction->get_customer_details($customerid);
		 
		if(empty($data['customer'])){
		// $this->promptError('ER:04:22');
		}else{
		//display the page
		$this->load->view('customer_details_xml', $data);
		}
			 
	 
	}	
	
	// View_API_User_by_Username()
	function nt_ViewAPIuserbyUsername(){
		$username = $this->input->get_post('username');
			
		if(!$username){
			$this->promptError('ER:04:12');
		}else{
				
					$dbAccess = $this->load->database('default',true);
				
					$dbAccess->select("
							c.customer_id
							,c.customer_username 
							, c.customer_firstname
							, c.customer_middlename
							, c.customer_lastname
							, c.customer_birthdate
							, c.customer_mobile
							, c.customer_email
							, c.customer_partycode
							, c.customer_address1
							, c.customer_address2
							, c.customer_city
							, c.customer_gender
							, c.customer_marital_status
							");
							

						$dbAccess->where("c.customer_username", $username);
						$query = $dbAccess->get('customers c');	

						$data['user'] = $query->row();
								
						if($query->num_rows() < 1){
									$this->promptError('ER:04:15');
								}else{
								//display the page
								$this->load->view('user_xml', $data);
								}
				
				
				
			}
			
	}
	
		// Register_party_user
	function nt_Register_party_user(){

 			$this->load->helper('email');
			$appcode = $this->input->post('appcode');
			$customer_username = $this->input->post('username');
			$customer_firstname = $this->input->post('fname');
			$customer_middlename = $this->input->post('mname');
			$customer_lastname = $this->input->post('lname');
			$customer_birthdate = $this->input->post('bdate');
			$customer_mobile = $this->input->post('mobile');
			$customer_email = $this->input->post('email');
			$customer_password = $this->input->post('password');
			$address = $this->input->post('address');
			$city = $this->input->post('city');
			$gender = $this->input->post('gender');
			$civil_status = $this->input->post('civil_status');
			
			  
				//Check username
				if(!trim($customer_username))
					{ 
					$this->promptError('ER:04:12');
					}	
				elseif($this->check_username(trim($customer_username)))
				{ 
					$this->promptError('ER:04:13');
				}					
				elseif(!$customer_password)
					{ 
					// $customer_password = 'ERROR: No Password Provided';
					$this->promptError('ER:04:03');
					}
				
				//Check FirstName
				elseif(!trim($customer_firstname))
					{
					// $customer_firstname = 'ERROR: No First Name Provided';
					$this->promptError('ER:04:04');
					}
					
					//Check LastName
				elseif(!trim($customer_lastname))
					{ 
					// $customer_lastname = 'ERROR: No Last Name Provided';
					$this->promptError('ER:04:05');
					}	
					
					
				//Check Date..Date should be in YYYY-MM-DD
				elseif (!$customer_birthdate)
						{
						// $customer_birthdate = 'ERROR: No Birth Date Provided';
						$this->promptError('ER:04:06');
						}
						
				//Returns TRUE if date format = YYYY-MM-DD
				elseif(!$this->isValidDate($customer_birthdate))
					{
					// $customer_birthdate = 'ERROR: Invalid date format';
					$this->promptError('ER:04:07');
					} 
					
				//Check mobile
				elseif(!trim($customer_mobile))
					{ 
					// $customer_mobile = 'ERROR: No Mobile Number Provided';
					$this->promptError('ER:04:08');
					} 	
					
				/* elseif(!$this->validate_phonenumbers(trim($customer_mobile)))
					{ 
					// $customer_mobile = 'ERROR:Invalid Mobile Format';
					$this->promptError('ER:04:11');
					}
					 */
			//Check existing mobile number		
			 	elseif($this->check_mobile(trim($customer_mobile)))
					{ 
					// $customer_mobile = 'ER:04:02' => 'Mobile Number Already Used',
					$this->promptError('ER:04:02');
					} 
				 
				 
				//Check if ther is a provided email
				elseif(!trim($customer_email))
					{ 
						// $customer_email = 'ERROR: No Email Provided';
						$this->promptError('ER:04:10');
					}
					
				//Check if email Adress string is valid
				elseif(!valid_email(trim($customer_email)))
					{ 
						// $customer_email = 'ERROR: Invalid Email Format';
						$this->promptError('ER:04:09');
					}
					
				//Check existing email
				/* elseif($this->check_email(trim($customer_email)))
					{ 
						// $customer_email = 'ERROR: No Email Provided';
						$this->promptError('ER:04:01');
					} */
					
				else{		
						$data = array(
					   'customer_firstname' => $customer_firstname,
					   'customer_middlename' => $customer_middlename,
					   'customer_lastname' => $customer_lastname,
					   'customer_birthdate' => $customer_birthdate,
					   'customer_mobile' => $customer_mobile,
					   'customer_email' => $customer_email,
					   'customer_username' => $customer_username,
					   'customer_active' => '1',
					   'customer_password' => $this->prep_password($customer_password),
					   // 'customer_partycode' => $customer_partycode,
					   'customer_address1' => $address,
					   'customer_city' => $city,
					   'customer_gender' => $gender,
					   'customer_marital_status' => $civil_status
						);
				 
						// I N S E R T		T O		D A T A B A S E
						$this->db->insert('customers', $data); 	
						
						$xml = '<result>Registration Succesful</result><id>'. $this->db->insert_id() . '</id>';
						foreach ($data as $key=>$value) 
						{
							if(substr($key, 9) !== 'password')
							{
								$xml = $xml . '<' .  substr($key, 9)  .'>' . $value . '</' . substr($key, 9). '>';
							}
						}	
						$data['content'] = $xml;
						$this->load->view("register_party_user_xml", $data);
			
					}
				 
			
			
			}
	  
	function nt_Reset_password(){
	
		// $livetoken = $this->input->get_post('livetoken');
		// $appcode = $this->input->get_post('appcode');
		$username = $this->input->get_post('user');
		$customer_birthdate = $this->input->post('bdate');
		$customer_email = $this->input->post('email');
		
		//Check if parameters are empty
		// if(!$appcode){
		// $data['content'] = 'ERROR: No AppCode Provided';
		// $this->promptError('ER:01:03');
		// }
		// elseif(!$livetoken){
		// $data['content'] = 'ERROR: No LiveToken Provided';
		// $this->promptError('ER:01:04');
		// }
		
			//$sessionStatus = $this->checkTokenStatus($appcode,$livetoken);			
			//if($sessionStatus == "nonexistent"){
			//$this->promptError('ER:02:02');
			//}elseif($sessionStatus == "expired"){
			// $this->promptError('ER:03:01');}
			
			if(!trim($username)){//check if there is a provided username
			$this->promptError('ER:04:12');
			}elseif(!$customer_birthdate){//Check Date..Date should be in YYYY-MM-DD
				// $customer_birthdate = 'ERROR: No Birth Date Provided';
			$this->promptError('ER:04:06');
			}elseif(!$this->isValidDate($customer_birthdate)){//Returns TRUE if date format = YYYY-MM-DD
			// $customer_birthdate = 'ERROR: Invalid date format';
			$this->promptError('ER:04:07');
			} 
			//Check if ther is a provided email
			elseif(!trim($customer_email)){ 
				// $customer_email = 'ERROR: No Email Provided';
				$this->promptError('ER:04:10');
			}else{
			
					// $dbAccess = $this->load->database('default',true);
					
					$this->db->select("customer_id");
					$this->db->where("customer_username", $username);
					$this->db->where("customer_birthdate",  $customer_birthdate);
					$this->db->where("customer_email",  $customer_email);
					$query = $this->db->get('customers');

					
					// echo $this->db->last_query();
					// die();
					
						if ($query->num_rows() < 1){
						$this->promptError('ER:02:11');
						}else{
						//Generate a reg key
						$reg_key = $this->encrypt->sha1($username.'MGI'.$customer_birthdate.'MGI'. $customer_email . 'MGI' . $this->getcurrentdatetime());
						
						//Save reset into api_sessions
						$data = array(
							'customer_registration_code' => $reg_key,
						);
						$this->db->where("customer_username",  $username);
						$this->db->update('customers', $data); 		
										
						// $xml = '<reset_key>'. $reg_key.'</reset_key>
							// <dateTimeActivated>'.$this->getcurrentdatetime().'</dateTimeActivated>';
						$xml = 	'<reset_key>'. $reg_key.'</reset_key>';
						
						$data['content'] = $xml;	
						$this->load->view("reset_xml", $data);

					}
			}

	}
	
	function nt_getNewEvents($limit=false){

	// $limit = 6;
	$dbAccess = $this->load->database('market',true);

	$dbAccess->select('e.event_id,	
				e.event_code,
				e.event_title,
				e.event_long_title,
				e.event_date_time,
				e.event_description,
				e.event_image,
				e.event_image_1,
				e.event_seatplan_id,
				e.event_recommended,
				s.seatplan_image,
				e.event_venue_id,
				v.venue_name,
				e.event_internet_sales_charge as convenience_charge,
				e.event_type,
				ec.events_config_ekbarcode_active,
				e.event_active,
				e.event_ticket_types,
				e.event_hotel,
				e.event_always_show,
				e.event_online_registration');
	

	$dbAccess->where("e.event_active",1);
	$dbAccess->where("e.event_date_time >= now()");
	$dbAccess->join('events_config ec', 'ec.events_config_eventid = e.event_id', 'left' );
	$dbAccess->join('seatplans s', 's.seatplan_id = e.event_seatplan_id', 'left' );
	$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
	
	if($limit)
	$dbAccess->limit($limit);
	
	
	$dbAccess->order_by('event_id', 'ASC');
	$query = $dbAccess->get('events e');

	$data['eventDetails'] = $query->result();

	//display the page
	$this->load->view('event_details_xml_NoDesc', $data);
	
	}
	
		 
	function nt_getVenueCountByEvent($limit=false){
		// die('test');
		// $limit = 6;
		$dbAccess = $this->load->database('market',true);

		$dbAccess->select('v.venue_name,
						v.venue_id,
						count(e.event_venue_id) as event_count');
			

		$dbAccess->where("e.event_active",1);
		$dbAccess->where("e.event_date_time >= now()");
		$dbAccess->join('events_config ec', 'ec.events_config_eventid = e.event_id', 'left' );
		$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
		if($limit)
		$dbAccess->limit($limit);
		$dbAccess->order_by('count(e.event_venue_id)', 'DESC');
		$dbAccess->group_by('e.event_venue_id');
		$query = $dbAccess->get('events e');

		// echo $dbAccess->last_query();
		 // die();
		
		$this->load->dbutil(); 
		$config = array (
						  'root'    => 'root',
						  'element' => 'element', 
						  'newline' => "\n", 
						  'tab'    => "\t"
						);

						
		echo $this->dbutil->xml_from_result($query, $config);
			 
	}
	
	function nt_GetAds(){
	
		/* $appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}else{ */
			
				/* $sessionStatus = $this->checkTokenStatus($appcode,$livetoken);
					
					if($sessionStatus == "nonexistent"){
					$this->promptError('ER:02:02');
					}elseif($sessionStatus == "expired"){
					$this->promptError('ER:03:01');
					}else{ */

					$dbAccess = $this->load->database('default',true);
  
					$queryString = "SELECT 
							a.ad_id
							,a.ad_path
							,a.ad_title
							,a.ad_type 
							,a.ad_filename
							,a.ad_link
							FROM (`ads` a)  
							WHERE `a`.`ad_active` = 'yes'";
				
					$query = $dbAccess->query($queryString);
					$data['adDetails'] = $query->result();
					
					/* echo "<pre>";
					print_r($data['adDetails']);
					echo "</pre>";
					die(); */
					
					//display the page
					$this->load->view('ads_xml', $data);
					
				// }
		// }
	}

	function get_barcode_for_ticket_printing($transaction_id = false, $accesscode = false) {


		$barcode = hash("crc32", $transaction_id);
		$barcode_hashed = strtoupper($barcode);

		$this->load->database('default',true);

		$this->db->select('apis.api_customer_id, cu.customer_email, cu.customer_id');
		$this->db->join('api_sessions apis', 'api_customer_id=cu.customer_id');
		$this->db->where('customer_active', 1);	
		$this->db->where('apis.api_accesscode', $accesscode);	
		$this->db->where('apis.api_active', 1);	
		$query_accesscode = $this->db->get('customers cu');
		$result_accesscode = $query_accesscode->result();

		if (json_encode($result_accesscode)) {

			$this->db->select('t.*, count(tix.ticket_id) as ticket_count, max(tix.ticket_event_id) as ticket_event_id , cu.customer_block as blocked, card_number_value as card_num, card_number_expiration as expiration, cu.customer_email');
			
			$this->db->join('tickets tix', 't.transaction_id = tix.ticket_transaction_id', 'LEFT');
			$this->db->join('customers cu', 'cu.customer_id = t.transaction_customer_id', 'LEFT');
			$this->db->join('card_numbers cn', 'cn.card_number_transaction_id = t.transaction_id', 'LEFT');
			$this->db->where('t.transaction_barcode', $barcode_hashed);
			$this->db->where('t.transaction_status', 'paid_online');	
			$this->db->where('tix.ticket_status', 'paid_online');	
			$this->db->where('cu.customer_block !=', 1);
			$this->db->group_by('t.transaction_id');
			$query = $this->db->get('transactions t');
			// $result = $query->result_array();
			$result = $query->result();

			if (($result) && ($result[0]->transaction_status !='done') && ($result_accesscode[0]->customer_id == $result[0]->transaction_customer_id)) {

				//xml response
				$this->load->view('ticket_by_barcode', array('info'=>$result));
				
				//json response
				// echo json_encode($result);

			}

			else {

				header ("Content-Type:text/xml");
				echo "<root>";
				echo "<message>Failed</message>";
				echo "</root>";

			}

		}

		else {

			header ("Content-Type:text/xml");
			echo "<root>";
			echo "<message>Access Code Failed</message>";
			echo "</root>";

		}

	}

	function get_password_for_ticket_printing() {

		$barcode = $this->input->post('barcode');
		$transaction_customer_id = $this->input->post('transaction_customer_id');
		$password = $this->input->post('password');
		$accesscode = $this->input->post('accesscode');

		// $barcode = "F776C6AB";
		// $transaction_customer_id = "612517";
		// $accesscode = "8dc3c86991bbeaccc73ad84deb674bb7ba6e96e4";
		// $username = "alinan.alfed";
		// $password = "alfedalinan";

		$hashed_password = sha1($this->config->item('encryption_key').$password);

		$this->load->database('default',true);
		
		$this->db->select('*');
		$this->db->join('tickets tix', 't.transaction_id = tix.ticket_transaction_id', 'LEFT');
		$this->db->join('customers cu', 'cu.customer_id = t.transaction_customer_id', 'LEFT');
		$this->db->join('api_sessions apis', 'apis.api_customer_id = t.transaction_customer_id', 'LEFT');
		$this->db->join('card_numbers cn', 'cn.card_number_transaction_id = t.transaction_id', 'LEFT');
		$this->db->where('t.transaction_barcode', $barcode);
		$this->db->where('t.transaction_customer_id', $transaction_customer_id);
		$this->db->where('cu.customer_password', $hashed_password);
		$this->db->where('apis.api_accesscode', $accesscode);
		$this->db->where('t.transaction_status', 'paid_online');	
		$this->db->where('tix.ticket_status', 'paid_online');	
		$this->db->where('cu.customer_block !=', 1);
		$this->db->where('apis.api_active', 1);
		$this->db->where('cu.customer_active', 1);
		$this->db->group_by('t.transaction_id');
		$query = $this->db->get('transactions t');
		$result = $query->result();
		$num_rows = $query->num_rows();

		// echo "<pre>";
		// print_r($num_rows);
		// echo "</pre>";
		// die();

		if (($num_rows==1) && ($result[0]->transaction_status!="done")) {

			header ("Content-Type:text/xml");
			echo "<root>";
			echo "<message>Success</message>";
			echo "</root>";

		}

		else {

			header ("Content-Type:text/xml");
			echo "<root>";
			echo "<message>Failed</message>";
			echo "</root>";

		}

	}	 	 
		

	/* 	
	function use_pincode(){
		
		$pincode = $this->input->get_post("pin");
		$refno = $this->input->get_post("refno");

		
		$ticket_count = 0;
		if(trim($pincode)){
		$dbAccess = $this->load->database('pincode',true);
		
			$data = array(
			'pin_status' => "pending",
			'pin_datetime' =>  date("Y-m-d H:i:s"),
			'pin_refno' => $refno
			);
		
			$dbAccess->where("pin_codes",$pincode);
			$dbAccess->where("pin_status","0");
	
			
			$dbAccess->update('pin_codes', $data); 
			
			$ticket_count = $dbAccess->affected_rows();
		}
			
			
			
			header ("Content-Type:text/xml");
			echo "<root>";
			if($ticket_count > 0){
				echo "<result>success</result>";
			}else{
				echo "<result>failed</result>";
			}		
			echo "</root>";
			
			
			
				
		$dbAccess = $this->load->database('default',true);
		die();
	
	}
		
	function check_pincode(){
		$pincode = $this->input->get_post("pin");
		$result = false;
		if(trim($pincode)){
			$dbAccess = $this->load->database('pincode',true);
			$dbAccess->where("pin_codes",$pincode);
			$dbAccess->where("pin_refno",'0');
			$dbAccess->where("pin_status","selected");
			$query = $dbAccess->get('pin_codes'); 
			$result = $query->num_rows();
		}
		
		header ("Content-Type:text/xml");
		echo "<root>";
		if($result){
			echo "<result>valid</result>";
		}else{
			echo "<result>invalid</result>";
		}		
		echo "</root>";
		
	}	
		
				
		 */		
				
				
				
				
				
	function view_pincode(){
		$this->tag_as_unsellected(); // auto unsellect all expired
		$pincode = $this->input->get_post("pin");
		$pin_set = $this->input->get_post("set");
		$result = false;		
		
		if(trim($pincode)){
			$dbAccess = $this->load->database('pincode',true);
			$dbAccess->where("pin_codes",$pincode);
			
			if($pin_set){	
				if(	$pin_set == "wanderland" ){
					$pin_set = array('globe15_1', 'globe15_2', 'globe15_3','globe15_4','globe15_5','globeGosurf25','globeTattoo15' );
					$dbAccess->where_in('pin_set', $pin_set);
				}else{
					$dbAccess->where("pin_set",$pin_set);
				}
			}
			
			$query = $dbAccess->get('pin_codes');
			$row = $query->row();
			
			header ("Content-Type:text/xml");
			echo "<root>";
			if($row){
				$status = array("selected","unsellected","0");
				if (in_array($row->pin_status, $status)) {
					$this->tag_as_selected($pincode);
						if($pin_set){
							echo "<result>". $row->pin_ticket_type_id	."</result>";
						}else{
							echo "<result>success</result>";
						}
				}else if($row->pin_status == "pending"){
					echo "<result>pending</result>";
				}else{
					echo "<result>invalid</result>";
				}	
			}else{
				echo "<result>invalid</result>";
			}
			
		}
		
		echo "</root>";
		
	}			
								
	function tag_as_selected($pincode){


		$dbAccess = $this->load->database('pincode',true);
			
			
		$data = array(
		'pin_status' => "selected",
		'pin_datetime' =>  date("Y-m-d H:i:s"),
		);

		$dbAccess->where("pin_codes",$pincode);
		$status = array('used', 'pending');
		$dbAccess->where_not_in('pin_status', $status);
		$dbAccess->update('pin_codes', $data); 		

	}			
					
	function tag_as_pending(){

		$pincode = $this->input->get_post("pin");
		$refno = $this->input->get_post("refno");

		$result = false;
		if(trim($pincode)){
			$dbAccess = $this->load->database('pincode',true);
			
				
			$data = array(
			'pin_status' => "pending",
			'pin_datetime' =>  date("Y-m-d H:i:s"),
			'pin_refno' => $refno
			);

			$dbAccess->where("pin_codes",$pincode);
			$status = array('used', 'pending');
			$dbAccess->where_not_in('pin_status', $status);
			$dbAccess->update('pin_codes', $data); 			
			$ticket_count = $dbAccess->affected_rows();
		}

		header ("Content-Type:text/xml");
		echo "<root>";
		if($ticket_count > 0){
			echo "<result>success</result>";
		}else{
			echo "<result>failed</result>";
		}		
		echo "</root>";
		
		$dbAccess = $this->load->database('default',true);
		die();
					
			
	}
							
	function tag_as_used(){

		$pincode = $this->input->get_post("pin");
		$refno = $this->input->get_post("refno");

		$result = false;
		if(trim($pincode)){
			$dbAccess = $this->load->database('pincode',true);
			
				
			$data = array(
			'pin_status' => "used",
			'pin_datetime' =>  date("Y-m-d H:i:s"),
			);

			$dbAccess->where("pin_codes",$pincode);
			$dbAccess->where('pin_status', 'pending');
			$dbAccess->where('pin_refno', $refno);
			
			$dbAccess->update('pin_codes', $data); 			
			$ticket_count = $dbAccess->affected_rows();
		}

		header ("Content-Type:text/xml");
		echo "<root>";
		if($ticket_count > 0){
			echo "<result>success</result>";
		}else{
			echo "<result>failed</result>";
		}		
		echo "</root>";
		
		$dbAccess = $this->load->database('default',true);
		die();
					
			
	}
									
	function tag_as_unsellected(){

		$date = date("Y-m-d H:i:s", strtotime(date("Y-m-d H:i:s")) - (15 * 60)); // NOW() - 15 minutes();
		

	
		// $pincode = $this->input->get_post("pin");
	
		$result = false;
		// if(trim($pincode)){
			$dbAccess = $this->load->database('pincode',true);
			
				
			$data = array(
			'pin_status' => "unsellected",
			'pin_datetime' => date("Y-m-d H:i:s"),
			'pin_refno' => ""
			);

			// $dbAccess->where("pin_codes",$pincode);
			$dbAccess->where('pin_status', 'pending');
			
			$dbAccess->where('pin_datetime <', $date );
			
			$dbAccess->where('pin_refno <>', '0');
			
			$dbAccess->update('pin_codes', $data); 			
			
			// echo $dbAccess->last_query();
			// die();
			
			$ticket_count = $dbAccess->affected_rows();
		// }

		// header ("Content-Type:text/xml");
		// echo "<root>";
	
			// echo "<result>$ticket_count tickets unsellected</result>";
		
		// echo "</root>";
		
		// $dbAccess = $this->load->database('default',true);
		// die();
					
			
	}
	
	function tag_as_unsellected_2(){

		$date = date("Y-m-d H:i:s", strtotime(date("Y-m-d H:i:s")) - (5 * 60)); // NOW() - 15 minutes();
		

	
		// $pincode = $this->input->get_post("pin");
	
		$result = false;
		// if(trim($pincode)){
			$dbAccess = $this->load->database('pincode',true);
			
				
			$data = array(
			'pin_status' => "unsellected",
			'pin_datetime' => date("Y-m-d H:i:s"),
			'pin_refno' => ""
			);

			// $dbAccess->where("pin_codes",$pincode);
			$dbAccess->where('pin_status', 'pending');
			
			$dbAccess->where('pin_datetime <', $date );
			
			$dbAccess->where('pin_refno <>', '0');
			
			$dbAccess->update('pin_codes', $data); 			
			
			echo $dbAccess->last_query();
			die();
			
			$ticket_count = $dbAccess->affected_rows();
		// }

		// header ("Content-Type:text/xml");
		// echo "<root>";
	
			// echo "<result>$ticket_count tickets unsellected</result>";
		
		// echo "</root>";
		
		// $dbAccess = $this->load->database('default',true);
		// die();
					
			
	}
				
	function reset_pincode(){
		
		$pincode = $this->input->get_post("pin");
		$ip = $this->input->get_post("ip"); 

		$ticket_count = 0;
		if(trim($pincode)){
		$dbAccess = $this->load->database('pincode',true);
		
			$data = array(
			'pin_status' => "0"
			);
		
			$dbAccess->where("pin_status <>",'used');
			$dbAccess->where("pin_codes",$pincode);
			$dbAccess->update('pin_codes', $data); 
			
			$ticket_count = $dbAccess->affected_rows();
		}
			
			
			
			header ("Content-Type:text/xml");
			echo "<root>";
			if($ticket_count > 0){
				echo "<result>success</result>";
			}else{
				echo "<result>failed</result>";
			}		
			echo "</root>";
			
		$this->logResets($pincode,$ip);
			
				
		$dbAccess = $this->load->database('default',true);
		die();
	
	}
		
		
		
		
		function logResets($pincode = false,$ip = false){
			
			if(trim($pincode)){
			$dbAccess = $this->load->database('pincode',true);
			
				$data = array(
				'reset_pincode' => $pincode,
				'reset_dateTime' =>  date("Y-m-d H:i:s"),
				'reset_ip' =>  $ip,
				);

				$dbAccess->insert('resets', $data); 
				
				
			return true;
			}
				
			
		}
		
		
		
		function test(){
			echo "kamote";
			die();
		}
		
		
		function countTicketsByUsername(){
			$username = $this->input->get_post("username");
			$event_id = $this->input->get_post("eventid"); 
			header ("Content-Type:text/xml");
			echo "<root>";
			echo "<result>" . 	$this->transaction->countTicketsByUsername($username,$event_id) . "</result>" ;
			echo "</root>";
		// die();
		}

		
		
		
		function nt_computePricebyticketType(){
			
			$price_id = $this->input->get_post("priceid");
			$ticket_type = $this->input->get_post("ticket_type"); 
			
			$dbAccess = $this->load->database('default',true);
			$dbAccess->where("ticket_type_id", $ticket_type);
			$query = $dbAccess->get("ticket_types"); 
			$ticket_type_array = $query->row();
			
			$discount_type = $ticket_type_array->ticket_type_discount_type;
			$discount = $ticket_type_array->ticket_type_discount;
		
			$dbAccess = $this->load->database('default',true);
			$dbAccess->where("price_id", $price_id);
			$query = $dbAccess->get("prices"); 
			$ticket_price = $query->row()->price_price;			
		
			$discounted_price = false;			
			if($discount_type == "Amount"){
				$discounted_price = $ticket_price - $discount;
			}else if($discount_type == "Percentage"){
				$discounted_price = $ticket_price - ( $ticket_price * ($discount/100) );
			}
			
			header ("Content-Type:text/xml");
			echo "<root>";
			echo "<price_id>$price_id</price_id>" ;
			echo "<price_amount>$discounted_price</price_amount>" ;
			echo "</root>";
		}
		
		
		/* 
		function nt_get_just_announced(){
			
			"Select * from events e where e.event_announcement_date = <> 'NULL' ";
			
		}
		 */
		
		
		
		function getEventIDs(){

			$json = $this->input->get_post('json');

				$dbAccess = $this->load->database('default',true);
				$dbAccess->select('	e.event_id');

				$dbAccess->where("e.event_active",'1');
				$dbAccess->where("e.event_date_time >= now()");
				$dbAccess->group_by("e.event_long_title");
				$dbAccess->order_by("e.event_id","desc");
				

		
				$query = $dbAccess->get('events e');
				
				$data['events'] = $query->result();

				 if(!$json){
					//display the page
					$this->load->view('event_ids_xml', $data);
				}else{
					
					echo json_encode($query->result());

					die();
				} 
				
				
		 
		}
		
		
	function getLastDateModified(){
		
		$dbAccess = $this->load->database('market',true);
		$dbAccess->select('e.date_modified as event_date_modified');
		$dbAccess->limit(1);
		$dbAccess->order_by('e.date_modified',"desc");
		$dbAccess->where("e.event_date_time >= now()");
		$query = $dbAccess->get('events e');
		
		header ("Content-Type:text/xml");
		echo "<root>";
		echo "<date_modified>" . $query->row()->event_date_modified . "</date_modified>";
		echo "</root>";
		die();

		if(!$json){
		//display the page
		die($events);
		$this->load->view('events_listing_xml', $data);
		}else{
		echo json_encode($query->result());
		die();
		} 
	}
		
}
/* End of file generic_mod.php */
/* Location: ./application/controllers/generic_mod.php */